<?php
abstract class SabaiFramework_Model_EntityCollection_Decorator extends SabaiFramework_Model_EntityCollection
{
    /**
     * @var SabaiFramework_Model_EntityCollection
     */
    protected $_collection;

    /**
     * Constructor
     *
     * @param SabaiFramework_Model_EntityCollection $collection
     * @param SabaiFramework_Model $model
     * @return SabaiFramework_Model_EntityCollection_Decorator
     */
    public function __construct(SabaiFramework_Model_EntityCollection $collection)
    {
        parent::__construct($collection->getModel(), $collection->getName());
        $this->_collection = $collection;
    }

    #[\ReturnTypeWillChange]
    public function offsetExists($index)
    {
        return $this->_collection->offsetExists($index);
    }

    #[\ReturnTypeWillChange]
    public function offsetGet($index)
    {
        return $this->_collection->offsetGet($index);
    }

    #[\ReturnTypeWillChange]
    public function offsetSet($index, $value)
    {
        $this->_collection->offsetSet($index, $value);
    }

    #[\ReturnTypeWillChange]
    public function offsetUnset($index)
    {
        $this->_collection->offsetUnset($index);
    }

    #[\ReturnTypeWillChange]
    public function count()
    {
        return $this->_collection->count();
    }

    #[\ReturnTypeWillChange]
    public function rewind()
    {
        $this->_collection->rewind();
    }

    #[\ReturnTypeWillChange]
    public function valid()
    {
        return $this->_collection->valid();
    }

    #[\ReturnTypeWillChange]
    public function next()
    {
        $this->_collection->next();
    }

    #[\ReturnTypeWillChange]
    public function current()
    {
        return $this->_collection->current();
    }

    #[\ReturnTypeWillChange]
    public function key()
    {
        return $this->_collection->key();
    }

}